/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static CompletableFuture<Suggestions> suggestRegistries(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource(((CommandSourceStack)ctx.getSource()).registryAccess().listRegistries().map(ResourceKey::location), (SuggestionsBuilder)builder);
    }

    public static <T extends Registry<?>> SuggestionProvider<CommandSourceStack> suggestFromRegistry(Function<Registry<?>, Iterable<ResourceLocation>> namesFunction, String argumentString, ResourceKey<Registry<T>> registryKey) {
        return (ctx, builder) -> CommandUtils.getResourceKey((CommandContext<CommandSourceStack>)ctx, argumentString, registryKey).flatMap(key -> ((CommandSourceStack)ctx.getSource()).registryAccess().registry(key).map(registry -> {
            SharedSuggestionProvider.suggestResource((Iterable)((Iterable)namesFunction.apply((Registry<?>)registry)), (SuggestionsBuilder)builder);
            return builder.buildFuture();
        })).orElseGet(() -> ((SuggestionsBuilder)builder).buildFuture());
    }

    public static <T> Optional<ResourceKey<T>> getResourceKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> registryKey) {
        ResourceKey key = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        return key.cast(registryKey);
    }
}

